from odoo import api, fields, models

from odoo.exceptions import ValidationError
import re, time

class PetTransaction(models.Model):
    _name = "pet.transaction"
    _rec_name = "pet_transaction_id"

    pet_transaction_id = fields.Char(string="Pet Transaction No", default="/")
    customer_id = fields.Many2one("customer", string="Customer", required=1)
    pet_shop_id = fields.Many2one("pet.shop", string="Pet Shop", required=1)
    pet_id = fields.Many2one("pet", string="Pet", required=1)
    transaction_date = fields.Date(string="Transaction Date", required=1, default=fields.Date.today())
    price = fields.Float(string="Total Price (RM)", compute="_compute_price", required=1)
    transaction_status = fields.Selection([
        ('pending', 'Pending'),
        ('complete', 'Complete')
    ], default="pending", required=1)

    #Create sequence id
    @api.model
    def create(self, vals):
        if vals.get('pet_transaction_id', False) == '/':
            vals['pet_transaction_id'] = self.env['ir.sequence'].next_by_code('pet.transaction.sequence')
            print(vals)
        return super(PetTransaction, self).create(vals)


    #once it select this B data, the other selection will based on this B data has (Give Domain For A Field Based On Another Field)
    @api.onchange('pet_shop_id')
    def _onchange_pet_shop_id(self):
        for record in self:
            if record.pet_shop_id != record.pet_shop_id:
                return {'domain': {'pet_id': [('pet_shop_id', '=', record.pet_shop_id.id), ('pet_status', '=', 'available')]}} # check whether the pet_status is available or not, if not it wont show in the selection list
            else:
                record.pet_id = None
                return {'domain': {'pet_id': [('pet_shop_id', '=', record.pet_shop_id.id), ('pet_status', '=', 'available')]}}


    #Status bar for pending and complete
    #Pet Shop there the available status will change to sold status
    def action_pending(self):
        for record in self:
            record.transaction_status = 'pending'
            record.pet_id.pet_status = 'available' # change in pet.py

    def action_complete(self):
        for record in self:
            record.transaction_status = 'complete'
            record.pet_id.pet_status = 'sold' # change in pet.py


    #If the status in pet.py is sold, the transaction will not let them buy
    @api.constrains('pet_id')
    def check_status(self):
        if self.pet_id.pet_status == "sold":
            raise ValidationError("Sorry, this pet is already sold out")

    #Auto change price when user select pet_id
    @api.depends('pet_id')
    @api.multi
    def _compute_price(self):
        for record in self:
            if not record.pet_id:
                record.price = 0.00
            else:
                record.price = record.pet_id.price



    

        

        
        
