from odoo import api, models, fields
import pendulum #calender

class Pet(models.Model):
    _name = "pet" # _ mean private, without _ mean public
    
    name = fields.Char(string="Pet Name", required=1)
    dob = fields.Date(string="Date Of Birth", required=1)
    age = fields.Integer(string="Age", compute="_compute_pet_age", store=1) #if we use compute, we need to use store because it will store the value in the database
    pet_types = fields.Char(string="Type of Pets", required=1)
    behavior_types = fields.Selection([
        ('cute', 'Cute'),
        ('obedient', 'Obedient'),
        ('playful', 'Playful')
    ], string="Behavior Types", default="cute")
    price = fields.Float(string="Price (RM)", required=1)
    pet_status = fields.Selection([
        ('available', 'Available'),
        ('sold', 'Sold')
    ], string="Status")
    pet_shop_id = fields.Many2one("pet.shop", string="Shop Name", required=1)

    #Generate the pet's age
    @api.depends('dob')
    @api.multi 
    def _compute_pet_age(self):
        for record in self:
            if record.dob:
                now = pendulum.now()
                dob = pendulum.parse(record.dob)
                age = (now - dob).years + 1
                record.age = age
            else:
                record.age = 0

    