from odoo import api, models, fields, exceptions

from odoo.exceptions import ValidationError
import re

class PetShop(models.Model):
    _name = "pet.shop" # only can use .

    name = fields.Char(string="Shop Name", required = 1)
    launch_date = fields.Date(string="Launch Date", required = 1)
    address = fields.Char(string="Address", required = 1)
    opening_hour = fields.Char(string="Operating Hours", required = 1)
    phone_no = fields.Char(string="Phone Number", required =1)
    email = fields.Char(string="Email", required=1)

    #Validation of email
    @api.constrains('email')
    def check_email(self):
        if self.email:
            match = re.match("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$", self.email)
        if match == None:
            raise ValidationError('Incorrect Email Format')

    #Validation of phone no
    @api.constrains('phone_no')
    def validate_phone(self):
        if self.phone_no:
            match = re.match("^(01)[0-46-9]*[0-9]{7,8}$", self.phone_no)
        if match == None:
            raise ValidationError('Incorrect Phone Number Format')

