from odoo import api, fields, models

class Product (models.Model):
    _name = "product"
    _rec_name = "product_name" # also can straight away change product_name to name

    pet_shop_id = fields.Many2one("pet.shop", string="Pet Shop", required=1)
    pet_types = fields.Char(string="Pet Types", required=1)
    product_types = fields.Char(string="Product / Supply Type", required=1)
    product_name = fields.Char(string="Product / Supply Name", required=1)
    price = fields.Float(string="Price (RM)", required=1)
    description = fields.Char(string="Description")
    quantity = fields.Integer(string="Quantity", required=1)

    
    