from odoo.exceptions import ValidationError
import re
from odoo import api,models,fields

class Staff(models.Model):
    _name = "staff"

    name = fields.Char(string="Staff Name", required=True)
    phone_no = fields.Char(string="Phone No", required=True)
    email = fields.Char(string="Email", required=True)

    @api.constrains('email')
    def check_email(self):
        if self.email:
            match = re.match("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$", self.email)
        if match == None:
            raise ValidationError('Incorrect Email Format')

    @api.constrains('phone_no')
    def check_phone(self):
        if self.phone_no:
            match = re.match("^(01)[0-46-9]*[0-9]{7,8}$", self.phone_no)
        if match == None:
            raise ValidationError('Incorrect Phone Number Format')