from odoo.exceptions import ValidationError
import re
from odoo import api,models,fields

class PetShop(models.Model):
    _name = "pet.shop"
    _rec_name = ""

    name = fields.Char(string="Pet Shop Name", required=True)
    address = fields.Char(string="Adress", required=True)
    launch_date = fields.Date(string="Launch Date", required=True)
    email = fields.Char(string="Email", required=True)
    phone_no = fields.Char(string="Phone No", required=True)

    @api.constrains('phone_no')
    def check_phone(self):
        if self.phone_no:
            match = re.match("^(01)[0-46-9]*[0-9]{7,8}$", self.phone_no)
        if match == None:
            raise ValidationError('Incorrect Phone Number Format')
