from odoo import api,models,fields
import pendulum #calander

class Pet(models.Model):
    _name = "pet.info"

    name = fields.Char(string="Pet Name", required=1)
    ptype = fields.Char(string="Pet Type", required=1)
    age = fields.Integer(string="Age", compute="_compute_pet_age", store=1)  #age = fields.Integer(string="Age", required=1)
    pet_shop_id = fields.Many2one("pet.shop", string="Pet's Shop")
    price = fields.Float(string="Price (RM)", default=0, required=1)
    dob = fields.Date(string="Date of Birth", required=1)
    pet_status = fields.Selection([
       ('available', 'Available'),
       ('sold', 'Sold'),
    ], string="Status", default="available", required=1)

    @api.depends('dob')
    @api.multi
    def _compute_pet_age(self):
        for record in self:
            if record.dob:
                now = pendulum.now()
                dob = pendulum.parse(record.dob)
                age = (now - dob).years + 1
                record.age = age
            else:
                record.age = 0