from odoo.exceptions import ValidationError
import re
from odoo import api,models,fields

class Transaction(models.Model):
    _name = "transaction.info"
    _rec_name = "transaction"

    transaction = fields.Char(default='/', string="Transaction ID")
    customer_id = fields.Many2one("customer", string="Customer Name", required=1)
    pet_shop_id = fields.Many2one("pet.shop", string="Pet's Shop", required=1)
    pet_ids = fields.Many2many("pet.info", string="Pets", required=1)
    status = fields.Selection([
       ('pending', 'Pending'),
       ('complete', 'Complete'),
    ], string="Status", default="pending", required=1)
    created_date = fields.Date(string="Created Date", required=True, default=fields.Date.today())

    total_amount = fields.Float(string="Total Amount (RM)", compute='_compute_total_amount', store=1)
    #payment_amount = fields.Float(string="Payment Amount (RM)")
    #payment_change = fields.Float(string='Payment Change (RM)', compute='_compute_payment_change', store=1)

    # Compute total amount
    @api.depends('pet_ids')
    @api.multi
    def _compute_total_amount(self):
        for record in self:
            if record.pet_ids:
                record.total_amount = sum(price.price for price in record.pet_ids)
            else:
                record.total_amount = 0

    # Compute payment change & payment amount
    #@api.depends('payment_amount', 'total_amount')
    #@api.multi
    #def _compute_payment_change(self):
        #for record in self:
            #if record.pet_ids:
                #record.payment_change = record.payment_amount - record.total_amount
            #else:
                #record.payment_change = 0
    
    # when user select pet_shop_id, pet_ids will show only that the pet_hop_ids have 
    @api.onchange('pet_shop_id')
    def onchange_pet_shop_id(self):
        for record in self:
            return {'domain': {'pet_ids': [('pet_shop_id', '=', record.pet_shop_id.id), ('pet_status', '=', 'available')]}}

    # For many2many, if transaction status & pet status is complete OR sold, it will change to pending & available
    @api.multi
    def action_pending(self):
        for record in self:
            record.status = 'pending'   #change transaction status to pending & run transaction status first
            for s1 in record.pet_ids:
                s1.pet_status = 'available' #change pet status from pet.py to pending & run pet status 

    @api.multi
    def action_complete(self):
        for record in self:
            record.status = 'complete'      #change transaction status to complete
            for s2 in record.pet_ids:   
                s2.pet_status = 'sold'      #change pet status from pet.py to sold & run pet status 

    # Auto-generate transaction ID
    @api.model
    def create(self, vals):
        if vals.get('transaction', False) == '/':
            vals['transaction'] = self.env['ir.sequence'].next_by_code('transaction.info.seq')
            #print(vals)
        return super(Transaction, self).create(vals)

    # Validation Error, validate the transaction status
    @api.constrains('status')
    def validate_status(self):
        for pet in self.pet_ids:
            if pet.pet_status == 'sold':
                raise ValidationError('Pet is sold')