from odoo import api,models,fields
import pendulum

class Services(models.Model):
    _name = "services.pet"
    _rec_name = "services"

    services = fields.Char(default='/', string="Services ID")
    staff_id = fields.Many2one("staff", string="Staff Name", required=1)
    pet_shop_id = fields.Many2one("pet.shop", string="Pet's Shop", required=1)
    pet_id = fields.Many2one("pet.info", string="Pets")
    #pet_shop_ids = fields.Many2many("pet.shop", string="Pet's Shop", required=True) ==> for select many shop
    grooming = fields.Char(string="Grooming", required=True)
    training = fields.Char(string="Training", required=True)
    price = fields.Float(string="Price (RM)", default=0, required=True)
    created_date = fields.Date(string="Created Date", required=True, default=fields.Date.today())

    @api.onchange('pet_shop_id')
    def onchange_pet_shop_id(self) :
        for record in self :
            return {'domain': 
                        {'pet_id': [('pet_shop_id', '=', record.pet_shop_id.id)]}
                   }
    
    @api.model
    def create(self, vals):
        if vals.get('services', False) == '/':
            vals['services'] = self.env['ir.sequence'].next_by_code('services.pet.seq')
            #print(vals)
        return super(Services, self).create(vals)